/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.upgrades.cooking;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.registry.FuelRegistry;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.SlottedStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageUtil;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_1874;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_3859;
import net.minecraft.class_3861;
import net.minecraft.class_3862;
import net.minecraft.class_3956;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.inventory.ITrackedContentsItemHandler;
import net.p3pp3rf1y.sophisticatedcore.renderdata.RenderInfo;
import net.p3pp3rf1y.sophisticatedcore.upgrades.FilterLogic;
import net.p3pp3rf1y.sophisticatedcore.upgrades.ITickableUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeItemBase;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeWrapperBase;
import net.p3pp3rf1y.sophisticatedcore.upgrades.cooking.AutoBlastingUpgradeItem;
import net.p3pp3rf1y.sophisticatedcore.upgrades.cooking.AutoCookingUpgradeConfig;
import net.p3pp3rf1y.sophisticatedcore.upgrades.cooking.AutoSmeltingUpgradeItem;
import net.p3pp3rf1y.sophisticatedcore.upgrades.cooking.AutoSmokingUpgradeItem;
import net.p3pp3rf1y.sophisticatedcore.upgrades.cooking.CookingLogic;
import net.p3pp3rf1y.sophisticatedcore.upgrades.cooking.CookingUpgradeRenderData;
import net.p3pp3rf1y.sophisticatedcore.upgrades.cooking.IAutoCookingUpgradeItem;
import net.p3pp3rf1y.sophisticatedcore.upgrades.cooking.ICookingUpgrade;
import net.p3pp3rf1y.sophisticatedcore.util.InventoryHelper;
import net.p3pp3rf1y.sophisticatedcore.util.RecipeHelper;

public class AutoCookingUpgradeWrapper<W extends AutoCookingUpgradeWrapper<W, U, R>, U extends UpgradeItemBase<W>, R extends class_1874>
extends UpgradeWrapperBase<W, U>
implements ITickableUpgrade,
ICookingUpgrade<R> {
    private static final int NOTHING_TO_DO_COOLDOWN = 10;
    private static final int NO_INVENTORY_SPACE_COOLDOWN = 60;
    private final FilterLogic inputFilterLogic;
    private final FilterLogic fuelFilterLogic;
    private final CookingLogic<R> cookingLogic;
    private final Predicate<class_1799> isValidInput;
    private final Predicate<class_1799> isValidFuel;
    private final class_3956<R> recipeType;
    private int outputCooldown = 0;
    private int fuelCooldown = 0;
    private int inputCooldown = 0;
    private final AutoCookingUpgradeConfig autoCookingUpgradeConfig;

    public AutoCookingUpgradeWrapper(IStorageWrapper storageWrapper, class_1799 upgrade, Consumer<class_1799> upgradeSaveHandler, class_3956<R> recipeType, float burnTimeModifier) {
        super(storageWrapper, upgrade, upgradeSaveHandler);
        this.recipeType = recipeType;
        this.autoCookingUpgradeConfig = ((IAutoCookingUpgradeItem)((Object)this.upgradeItem)).getAutoCookingUpgradeConfig();
        this.inputFilterLogic = new FilterLogic(upgrade, upgradeSaveHandler, (Integer)this.autoCookingUpgradeConfig.inputFilterSlots.get(), s -> RecipeHelper.getCookingRecipe(s, recipeType).isPresent(), "inputFilter");
        this.fuelFilterLogic = new FilterLogic(upgrade, upgradeSaveHandler, (Integer)this.autoCookingUpgradeConfig.fuelFilterSlots.get(), s -> Objects.requireNonNullElse((Integer)FuelRegistry.INSTANCE.get((class_1935)s.method_7909()), 0) > 0, "fuelFilter");
        this.fuelFilterLogic.setAllowByDefault(true);
        this.fuelFilterLogic.setEmptyAllowListMatchesEverything();
        this.isValidInput = s -> RecipeHelper.getCookingRecipe(s, recipeType).isPresent() && this.inputFilterLogic.matchesFilter((class_1799)s);
        this.isValidFuel = s -> Objects.requireNonNullElse((Integer)FuelRegistry.INSTANCE.get((class_1935)s.method_7909()), 0) > 0 && this.fuelFilterLogic.matchesFilter((class_1799)s);
        this.cookingLogic = new CookingLogic<R>(upgrade, upgradeSaveHandler, this.isValidFuel, this.isValidInput, this.autoCookingUpgradeConfig, recipeType, burnTimeModifier);
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (!enabled) {
            this.pauseAndRemoveRenderInfo();
        }
        super.setEnabled(enabled);
    }

    private void pauseAndRemoveRenderInfo() {
        this.cookingLogic.pause();
        RenderInfo renderInfo = this.storageWrapper.getRenderInfo();
        renderInfo.removeUpgradeRenderData(CookingUpgradeRenderData.TYPE);
    }

    @Override
    public void onBeforeRemoved() {
        this.pauseAndRemoveRenderInfo();
    }

    private void tryPushingOutput() {
        if (this.outputCooldown > 0) {
            --this.outputCooldown;
            return;
        }
        try (Transaction ctx = Transaction.openOuter();){
            class_1799 output = this.cookingLogic.getCookOutput();
            ItemVariant outputResource = ItemVariant.of((class_1799)output);
            ITrackedContentsItemHandler inventory = this.storageWrapper.getInventoryForUpgradeProcessing();
            if (!output.method_7960() && StorageUtil.simulateInsert((Storage)inventory, (Object)outputResource, (long)output.method_7947(), (TransactionContext)ctx) > 0L) {
                long ret = inventory.insert(outputResource, output.method_7947(), (TransactionContext)ctx);
                this.cookingLogic.getCookingInventory().extractSlot(2, outputResource, ret, (TransactionContext)ctx);
            } else {
                this.outputCooldown = 60;
            }
            class_1799 fuel = this.cookingLogic.getFuel();
            ItemVariant fuelResource = ItemVariant.of((class_1799)fuel);
            if (!fuel.method_7960() && Objects.requireNonNullElse((Integer)FuelRegistry.INSTANCE.get((class_1935)fuelResource.getItem()), 0) <= 0 && StorageUtil.simulateInsert((Storage)inventory, (Object)fuelResource, (long)fuel.method_7947(), (TransactionContext)ctx) > 0L) {
                long ret = inventory.insert(fuelResource, fuel.method_7947(), (TransactionContext)ctx);
                this.cookingLogic.getCookingInventory().extractSlot(1, fuelResource, ret, (TransactionContext)ctx);
            }
            ctx.commit();
        }
    }

    @Override
    public void tick(@Nullable class_1297 entity, class_1937 world, class_2338 pos) {
        if (this.isInCooldown(world)) {
            return;
        }
        this.tryPushingOutput();
        this.tryPullingFuel();
        this.tryPullingInput();
        if (!this.cookingLogic.tick(world) && this.outputCooldown <= 0 && this.fuelCooldown <= 0 && this.inputCooldown <= 0) {
            this.setCooldown(world, 10);
        }
        boolean isBurning = this.cookingLogic.isBurning(world);
        RenderInfo renderInfo = this.storageWrapper.getRenderInfo();
        if (renderInfo.getUpgradeRenderData(CookingUpgradeRenderData.TYPE).map(CookingUpgradeRenderData::isBurning).orElse(false) != isBurning) {
            if (isBurning) {
                renderInfo.setUpgradeRenderData(CookingUpgradeRenderData.TYPE, new CookingUpgradeRenderData(true));
            } else {
                renderInfo.removeUpgradeRenderData(CookingUpgradeRenderData.TYPE);
            }
        }
    }

    private void tryPullingInput() {
        if (this.inputCooldown > 0) {
            --this.inputCooldown;
            return;
        }
        if (this.tryPullingGetUnsucessful(this.cookingLogic.getCookInput(), this.cookingLogic::setCookInput, this.isValidInput)) {
            this.inputCooldown = 60;
        }
    }

    private void tryPullingFuel() {
        if (this.fuelCooldown > 0) {
            --this.fuelCooldown;
            return;
        }
        if (this.tryPullingGetUnsucessful(this.cookingLogic.getFuel(), this.cookingLogic::setFuel, this.isValidFuel)) {
            this.fuelCooldown = 60;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean tryPullingGetUnsucessful(class_1799 stack, Consumer<class_1799> setSlot, Predicate<class_1799> isItemValid) {
        class_1799 toExtract;
        ITrackedContentsItemHandler inventory = this.storageWrapper.getInventoryForUpgradeProcessing();
        if (stack.method_7960()) {
            AtomicReference<class_1799> ret = new AtomicReference<class_1799>(class_1799.field_8037);
            InventoryHelper.iterate((SlottedStorage<ItemVariant>)inventory, (slot, st) -> {
                if (isItemValid.test((class_1799)st)) {
                    ret.set(st.method_7972());
                }
            }, () -> !((class_1799)ret.get()).method_7960());
            if (ret.get().method_7960()) return true;
            toExtract = ret.get();
            toExtract.method_7939(toExtract.method_7914());
        } else {
            if (stack.method_7947() == stack.method_7914() || !isItemValid.test(stack)) {
                return true;
            }
            toExtract = stack.method_7972();
            toExtract.method_7939(stack.method_7914() - stack.method_7947());
        }
        try (Transaction ctx = Transaction.openOuter();){
            long extracted = inventory.extract(ItemVariant.of((class_1799)toExtract), toExtract.method_7947(), (TransactionContext)ctx);
            if (extracted > 0L) {
                class_1799 toSet = toExtract.method_46651((int)extracted);
                toSet.method_7933(stack.method_7947());
                setSlot.accept(toSet);
                ctx.commit();
                return false;
            }
            boolean bl = true;
            return bl;
        }
    }

    @Override
    public CookingLogic<R> getCookingLogic() {
        return this.cookingLogic;
    }

    public FilterLogic getInputFilterLogic() {
        return this.inputFilterLogic;
    }

    public FilterLogic getFuelFilterLogic() {
        return this.fuelFilterLogic;
    }

    public static class AutoBlastingUpgradeWrapper
    extends AutoCookingUpgradeWrapper<AutoBlastingUpgradeWrapper, AutoBlastingUpgradeItem, class_3859> {
        public AutoBlastingUpgradeWrapper(IStorageWrapper storageWrapper, class_1799 upgrade, Consumer<class_1799> upgradeSaveHandler) {
            super(storageWrapper, upgrade, upgradeSaveHandler, class_3956.field_17547, 0.5f);
        }
    }

    public static class AutoSmokingUpgradeWrapper
    extends AutoCookingUpgradeWrapper<AutoSmokingUpgradeWrapper, AutoSmokingUpgradeItem, class_3862> {
        public AutoSmokingUpgradeWrapper(IStorageWrapper storageWrapper, class_1799 upgrade, Consumer<class_1799> upgradeSaveHandler) {
            super(storageWrapper, upgrade, upgradeSaveHandler, class_3956.field_17548, 0.5f);
        }
    }

    public static class AutoSmeltingUpgradeWrapper
    extends AutoCookingUpgradeWrapper<AutoSmeltingUpgradeWrapper, AutoSmeltingUpgradeItem, class_3861> {
        public AutoSmeltingUpgradeWrapper(IStorageWrapper storageWrapper, class_1799 upgrade, Consumer<class_1799> upgradeSaveHandler) {
            super(storageWrapper, upgrade, upgradeSaveHandler, class_3956.field_17546, 1.0f);
        }
    }
}

